//
//	Class definition for the Game State
//
//	- uses ldwGameState as base class
//

#ifndef THE_BUTTERFLY_CLASS_H
#define THE_BUTTERFLY_CLASS_H

//#include "ldwGameState.h"
//#include "WorldMap.h"
//#include "isola.h"
#include "../Game/theGameState.h"
#include "ldwGameWindow.h"
#include "ldwTypes.h"
//#include "theSoundFxManager.h"

//class theGameState;
class ldwGameWindow;
class CVillagerMgr;

#define maxNumButterlies 5
#define defaultButterflyAnimSpeed	2
#define numButterflySets			4

typedef enum
{
	chasing,
	landing,
	sunning,
	fluttering,
	followingGC,
	polinating

}	ButterflyStateType;

typedef struct
{
	
	ldwPoint			m_sPos;
	ldwPoint			m_sVel;
	ldwPoint			m_sTarget;
	ldwPoint			m_sLandingTarget;
	int type;
	int wingPosition;
	int wingMotionIdx;
	int scale;
	ButterflyStateType butterflyState;

} ButterflyType;

class theButterflyClass 
{
public:

	static theButterflyClass * Get();
	static void Destroy();

	~theButterflyClass();

	ldwImageGrid *greenButterfly;
	void NormVel(int whichButterfly);
	void AcquireTarget(int whichButterfly, int x, int y);
	void AcquireTarget(int whichButterfly);

	void InitButterflies();
	void SpawnButterflies(bool tinyButterflies = false);
	void UpdateButterflies(ldwPoint mousePos);
	void UpdateMiniButterflies();
	void DrawButterflies(bool tinyButterflies = false);
	void ChangeButterflyStates(ButterflyStateType whatState, bool tinyButterflies = false);

	//array of villager's temporal data
	//tools for set/get of villager's persistant data

	
protected:

	ButterflyType butterflies[maxNumButterlies];

	//protected constructor.  called internally from Get()
	theButterflyClass();
	static theButterflyClass *mInstance;

	ldwPoint groupTarget;
	int groupIndexCounter;

	ldwGameWindow *gameWindow;
	theGameState *gs;
};

#endif
